import 'package:file_selector/file_selector.dart';
class FilePikerHelper {

  // Pick a single file (pdf, doc, images, etc)
  static Future<XFile?> pickFile({bool isImage = false}) async {

    final typeGroup = XTypeGroup(
      label: 'documents',
      extensions: isImage ? ['jpg', 'jpeg', 'png'] : ['pdf', 'doc', 'docx', 'txt', 'jpg', 'jpeg', 'png'],
    );
    final XFile? file = await openFile(acceptedTypeGroups: [typeGroup]);
    return file; // may be null if user cancelled
  }

  static Future<List<XFile>?> pickFiles() async {
    final typeGroup = XTypeGroup(
      label: 'documents',
      extensions: ['pdf', 'doc', 'docx', 'txt', 'jpg', 'jpeg', 'png'],
    );

    final List<XFile>? files = await openFiles(acceptedTypeGroups: [typeGroup]);
    return files;
  }

}